/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.collect.AbstractIterator;
import cz.insophy.inplan.util.TimeSpan;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;

public final class CalendarHelper {
    private CalendarHelper() {
    }

    public static long getThisDayStart() {
        Calendar c = Calendar.getInstance();
        CalendarHelper.setDayStart(c);
        return c.getTimeInMillis();
    }

    public static boolean isDayStart(Calendar calendar) {
        return CalendarHelper.isCalendarFieldMin(calendar, 11) && CalendarHelper.isCalendarFieldMin(calendar, 12) && CalendarHelper.isCalendarFieldMin(calendar, 13) && CalendarHelper.isCalendarFieldMin(calendar, 14);
    }

    private static boolean isCalendarFieldMin(Calendar calendar, int field) {
        return calendar.get(field) == 0;
    }

    public static Calendar setDayStart(Calendar calendar) {
        CalendarHelper.setCalendarFieldMin(calendar, 11);
        CalendarHelper.setCalendarFieldMin(calendar, 12);
        CalendarHelper.setCalendarFieldMin(calendar, 13);
        CalendarHelper.setCalendarFieldMin(calendar, 14);
        return calendar;
    }

    private static void setCalendarFieldMin(Calendar calendar, int field) {
        calendar.set(field, 0);
    }

    public static boolean isDayEnd(Calendar calendar) {
        return CalendarHelper.isCalendarFieldMax(calendar, 11) && CalendarHelper.isCalendarFieldMax(calendar, 12) && CalendarHelper.isCalendarFieldMax(calendar, 13) && CalendarHelper.isCalendarFieldMax(calendar, 14);
    }

    private static boolean isCalendarFieldMax(Calendar calendar, int field) {
        return calendar.get(field) == calendar.getMaximum(field);
    }

    public static Calendar setDayEnd(Calendar calendar) {
        CalendarHelper.setCalendarFieldMax(calendar, 11);
        CalendarHelper.setCalendarFieldMax(calendar, 12);
        CalendarHelper.setCalendarFieldMax(calendar, 13);
        CalendarHelper.setCalendarFieldMax(calendar, 14);
        return calendar;
    }

    private static void setCalendarFieldMax(Calendar calendar, int field) {
        calendar.set(field, calendar.getMaximum(field));
    }

    public static Calendar setWeekStart(Calendar calendar) {
        while (calendar.get(7) != 2) {
            calendar.add(5, -1);
        }
        CalendarHelper.setDayStart(calendar);
        return calendar;
    }

    public static Calendar setMonthStart(Calendar calendar) {
        while (calendar.get(5) != 1) {
            calendar.add(5, -1);
        }
        CalendarHelper.setDayStart(calendar);
        return calendar;
    }

    public static Calendar setYearStart(Calendar calendar) {
        CalendarHelper.setMonthStart(calendar);
        while (calendar.get(2) != 0) {
            calendar.add(2, -1);
        }
        CalendarHelper.setDayStart(calendar);
        return calendar;
    }

    public static Calendar setWeekEnd(Calendar calendar) {
        while (calendar.get(7) != 1) {
            calendar.add(5, 1);
        }
        CalendarHelper.setDayEnd(calendar);
        return calendar;
    }

    public static Calendar setMonthEnd(Calendar calendar) {
        Calendar c = CalendarHelper.setMonthStart(calendar);
        c.add(2, 1);
        c.add(5, -1);
        CalendarHelper.setDayEnd(c);
        return c;
    }

    public static Calendar setYearEnd(Calendar calendar) {
        Calendar c = CalendarHelper.setYearStart(calendar);
        c.add(1, 1);
        c.add(5, -1);
        CalendarHelper.setDayEnd(c);
        return c;
    }

    public static int howManyFitsBetween(int field, long startDate, long endDate) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startDate);
        int count = 0;
        while (true) {
            c.add(field, 1);
            if (c.getTimeInMillis() > endDate) break;
            ++count;
        }
        return count;
    }

    public static void addDays(Calendar c, int d) {
        c.add(5, d);
    }

    public static void addWeeks(Calendar c, int w) {
        c.add(5, 7 * w);
    }

    public static void addMonths(Calendar c, int m3) {
        c.add(2, m3);
    }

    public static void addYears(Calendar c, int y) {
        c.add(1, y);
    }

    public static long addDays(long t, int d) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        CalendarHelper.addDays(c, d);
        return c.getTimeInMillis();
    }

    public static long addWeeks(long t, int w) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        CalendarHelper.addWeeks(c, w);
        return c.getTimeInMillis();
    }

    public static long addMonths(long t, int m3) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        CalendarHelper.addMonths(c, m3);
        return c.getTimeInMillis();
    }

    public static long addYears(long t, int y) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(t);
        CalendarHelper.addYears(c, y);
        return c.getTimeInMillis();
    }

    public static Iterable<TimeSpan> splitAtMidnight(final long start, final long end) {
        return () -> new AbstractIterator<TimeSpan>(){
            ZonedDateTime from;
            ZonedDateTime to;
            {
                this.from = Instant.ofEpochMilli(start).atZone(ZoneId.systemDefault());
                this.to = Instant.ofEpochMilli(end).atZone(ZoneId.systemDefault());
            }

            @Override
            protected TimeSpan computeNext() {
                if (!this.from.isBefore(this.to)) {
                    return (TimeSpan)this.endOfData();
                }
                ZonedDateTime chunkTo = this.from.truncatedTo(ChronoUnit.DAYS).equals(this.to.truncatedTo(ChronoUnit.DAYS)) ? this.to : this.from.truncatedTo(ChronoUnit.DAYS).plusDays(1L);
                TimeSpan res = TimeSpan.fromStartEnd(this.from.toInstant().toEpochMilli(), chunkTo.toInstant().toEpochMilli());
                this.from = chunkTo;
                return res;
            }
        };
    }
}

